/*
 * Decompiled with CFR 0.152.
 */
package com.smart.io;

import android.util.Log;
import com.smart.io.PortManager;
import com.smart.io.WriterResult;
import com.smart.utils.SerialPortControl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class SerialPort
extends PortManager {
    private static final String TAG = "SerialPort";
    private int baudrate;
    private String serialPortPath;
    private int flags;
    private SerialPortControl serialPortControl;

    public SerialPort(String path, int baudrate, int flags) {
        this.serialPortPath = path;
        this.baudrate = baudrate;
        this.flags = flags;
    }

    public SerialPort() {
    }

    public void setSerialPortPath(String path) {
        this.serialPortPath = path;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    public void setFlage(int flags) {
        this.flags = flags;
    }

    @Override
    public boolean openPort() {
        try {
            File file = new File(this.serialPortPath);
            if (file.exists()) {
                this.serialPortControl = new SerialPortControl(file, this.baudrate, this.flags);
                this.inputStream = this.serialPortControl.getInputStream();
                this.outputStream = this.serialPortControl.getOutputStream();
                if (this.inputStream != null && this.outputStream != null) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Open serial port error!", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isConnect() {
        return false;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        if (data == null || data.size() <= 0) {
            throw new IllegalArgumentException("Data is empty or size is 0.");
        }
        this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
        this.outputStream.flush();
    }

    @Override
    public void writeDataImadiately(Vector<Byte> data, int offset, int len, long timeout, WriterResult error) {
        if (data == null || data.size() <= 0) {
            error.error(-3);
        }
        try {
            if (this.outputStream != null) {
                if (data != null && data.size() > 0) {
                    this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                    this.outputStream.flush();
                }
            } else {
                error.error(-2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            error.error(-1);
        }
    }

    @Override
    public void writeDataImadiately(byte[] data) throws IOException {
    }

    @Override
    public boolean readData(byte[] bytes, int len, long timeout) throws IOException {
        if (this.inputStream == null) {
            return false;
        }
        int i = 0;
        while ((long)i < timeout / 5L) {
            if (this.inputStream.available() == len) {
                this.inputStream.read(bytes, 0, len);
                return true;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean closePort() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.serialPortControl != null) {
                this.serialPortControl.close();
            }
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close the steam or serial port error!", (Throwable)e);
            return false;
        }
    }
}

